<?php
/*
 * Created by Artureanec
*/

$organium_customizer_default_values = array(
    # Header Settings

        #General
        'header_style' => 'type_1',
        'header_position' => 'above',
        'sticky_header' => 'off',

        # Header Logo
        'logo_image' => '',
        'logo_retina' => false,

        # Header Social Buttons
        'header_socials' => 'off',
        'header_socials_font_size' => '13px',
        'header_socials_type' => 'bg',

        # Header Button
        'header_button' => 'off',
        'header_button_text' => esc_html__('Purchase Organium', 'organium'),
        'header_button_url' => '#',

        # Header Menu
        'header_menu_font_family' => 'Nunito',
        'header_menu_font_size' => '16px',
        'header_menu_line_height' => '1.5',
        'header_menu_font_weight' => '700',
        'header_menu_uppercase' => false,
        'header_menu_italic' => false,
        'header_sub_menu_font_family' => 'Nunito',
        'header_sub_menu_font_size' => '16px',
        'header_sub_menu_line_height' => '1.5',
        'header_sub_menu_font_weight' => '600',
        'header_sub_menu_uppercase' => false,
        'header_sub_menu_italic' => false,

        # Side Panel
        'side_panel' => 'off',
        'side_panel_trigger_type' => 'large',

        # Header Search
        'header_search' => 'on',

        # Header Minicart
        'header_minicart' => 'on',

        # Header Wishlist
        'header_wishlist' => 'off',

    # Typography

        # Main Font
        'main_font_family' => 'Nunito',
        'main_font_size' => '16px',
        'main_line_height' => '1.7',
        'main_font_weight' => '400',

        # Additional Font
        'additional_font_family' => 'Meddon',
        'additional_font_weight' => '400',

        # Headings
        'headings_font_family' => 'Nunito',
        'headings_font_weight' => '700',
        'headings_uppercase' => false,
        'headings_italic' => false,
        'h1_font_size' => '70px',
        'h1_line_height' => '1.2',
        'h2_font_size' => '50px',
        'h2_line_height' => '1.2',
        'h3_font_size' => '40px',
        'h3_line_height' => '1.2',
        'h4_font_size' => '30px',
        'h4_line_height' => '1.2',
        'h5_font_size' => '25px',
        'h5_line_height' => '1.2',
        'h6_font_size' => '20px',
        'h6_line_height' => '1.2',

        # Buttons
        'buttons_font_family' => 'Nunito',
        'buttons_font_size' => '12px',
        'buttons_font_weight' => '700',
        'buttons_uppercase' => true,
        'buttons_italic' => false,

        # Page Title
        'site_title_font_family' => 'Nunito',
        'site_title_font_size' => '30px',
        'page_title_font_family' => 'Nunito',
        'page_title_font_size' => '70px',
        'title_additional_text_font_family' => 'Meddon',
        'title_additional_text_font_size' => '225px',

    # Social Links

        'socials_target' => false,
        'socials_facebook' => '',
        'socials_twitter' => '',
        'socials_linkedin' => '',
        'socials_youtube' => '',
        'socials_instagram' => '',
        'socials_pinterest' => '',
        'socials_tumbl' => '',
        'socials_flickr' => '',
        'socials_vk' => '',
        'socials_dribbble' => '',
        'socials_vimeo' => '',
        'socials_500px' => '',
        'socials_xing' => '',
        'socials_facebook_text' => '',
        'socials_twitter_text' => '',
        'socials_linkedin_text' => '',
        'socials_youtube_text' => '',
        'socials_instagram_text' => '',
        'socials_pinterest_text' => '',
        'socials_tumbl_text' => '',
        'socials_flickr_text' => '',
        'socials_vk_text' => '',
        'socials_dribbble_text' => '',
        'socials_vimeo_text' => '',
        'socials_500px_text' => '',
        'socials_xing_text' => '',

    # Color Options

        # General
        'site_bg_color'                 => '#ffffff',
        'main_color'                    => '#fa6c47',
        'accent_color'                  => '#a5bd3a',
        'main_font_color'               => '#818181',
        'headings_color'                => '#2d3131',
        'listing_titles_color'          => '#2d3131',
        'listing_titles_hover'          => '#fa6c47',

        # Side Panel
        'side_panel_bg'                 => '#ffffff',
        'side_panel_close_color'        => '#282a43',
        'side_panel_close_hover'        => '#282a43',

        # Header
            # Header General
            'header_bg'                 => '#ffffff',
            'header_bd'                 => '#f7f6f1',

            # Logo
            'header_logo_color'         => '#2d3131',

            # Header Social Buttons
            'header_socials_icon_color' => '#2d3131',
            'header_socials_icon_hover' => '#ffffff',
            'header_socials_bg_color'   => '#eceae4',
            'header_socials_bg_hover'   => '#fa6c47',

            # Header Button
            'header_button_color'       => '#ffffff',
            'header_button_hover'       => '#ffffff',
            'header_button_bg_color'    => '#fa6c47',
            'header_button_bg_hover'    => '#fa6c47',

            # Header Menu
            'header_menu_color'         => '#2d3131',
            'header_menu_hover'         => '#fa6c47',
            'header_sub_menu_color'     => '#2d3131',
            'header_sub_menu_hover'     => '#fa6c47',
            'header_sub_menu_bg'        => '#ffffff',

            # Side Panel Trigger
            'side_panel_trigger_color'  => '#ffffff',
            'side_panel_trigger_hover'  => '#ffffff',
            'side_panel_trigger_bg_color'   => '#fa6c47',
            'side_panel_trigger_bg_hover'   => '#a5bd3a',

            # Header Search
            'header_search_trigger_color'   => '#2d3131',
            'header_search_trigger_hover'   => '#fa6c47',

            # Header Mini Cart
            'header_minicart_icon_color'    => '#2d3131',
            'header_minicart_icon_hover'    => '#2d3131',
            'header_minicart_bg_color'      => '#f7f6f2',
            'header_minicart_bg_hover'      => '#f7f6f2',
            'header_minicart_counter_color' => '#ffffff',
            'header_minicart_counter_bg'    => '#fa6c47',

            # Header Wishlist
            'header_wishlist_color'         => '#2d3131',
            'header_wishlist_hover'         => '#fa6c47',

        # Buttons
        'button_color' => '#ffffff',
        'button_hover' => '#ffffff',
        'button_bg_color' => '#fa6c47',
        'button_bg_hover' => '#fb8a6b',
        'button_alter_color' => '#ffffff',
        'button_alter_hover' => '#ffffff',
        'button_alter_bg_color' => '#a5bd3a',
        'button_alter_bg_hover' => '#b4ce41',
        'post_socials_color' => '#343877',
        'post_socials_hover' => '#343877',
        'post_socials_bg' => '#ffffff',
        'post_socials_bg_hover' => '#efc940',


        # Footer
            # General
            'footer_bg' => '#f7f6f1',
            'footer_text_color' => '#818181',
            'footer_accent_color' => '#2d3131',
            'footer_hover_color' => '#ff7854',

            # Logo
            'footer_logo_color' => '#2d3131',

            # Sidebar
            'footer_sidebar_text_color' => '#818181',
            'footer_sidebar_accent_color' => '#2d3131',
            'footer_sidebar_hover_color' => '#ff7854',

            # Footer Menu
            'footer_menu_color' => '#2d3131',
            'footer_menu_hover' => '#ff7854',
            'footer_menu_border_color' => '#e0e0e0',

            # Footer Socials
            'footer_socials_color' => '#ffffff',
            'footer_socials_hover' => '#ffffff',
            'footer_socials_bg' => '#a5bd3a',
            'footer_socials_bg_hover' => '#fa6c47',

            # Footer Button
            'footer_button_color' => '#ffffff',
            'footer_button_hover' => '#ffffff',
            'footer_button_shadow' => '',
            'footer_button_bg_color' => '#fa6c47',
            'footer_button_bg_hover' => '#fb8a6b',
            'footer_button_hover_shadow' => 'rgba(250, 108, 71, 0.24)',

        # Page Title
        'post_title_bg_color' => '#f7f6f1',
        'page_title_color' => '#2d3131',
        'title_additional_text_color' => '#f1efe9',
        'breadcrumbs_text_color' => '#2d3131',
        'breadcrumbs_link_color' => '#9c9c9c',
        'breadcrumbs_link_hover' => '#fa6c47',

        # Forms
        'form_field_color' => '#000000',
        'form_field_bg' => '#ffffff',
        'form_field_border' => '#e0e0e0',
        'active_form_field_bg' => '#ffffff',
        'active_form_field_border' => '#777777',
        'form_button_color' => '#ffffff',
        'form_button_hover' => '#ffffff',
        'form_button_bg' => '#fa6c47',
        'form_button_bg_hover' => '#fa6c47',

    # Footer

        # General
        'footer_status' => 'show',
        'footer_style' => 'style_1',
        'footer_bg_image' => get_template_directory_uri() . '/img/footer-bg.jpg',
        'footer_bg_position' => 'center center',
        'footer_bg_repeat' => 'no-repeat',
        'footer_bg_size' => 'cover',

        # Footer Logo
        'footer_logo_status' => 'show',
        'footer_logo_image' => '',
        'footer_logo_retina' => false,

        # Footer Sidebar
        'footer_sidebar_status' => 'hide',
        'footer_sidebar_select' => 'sidebar-footer-style1',

        # Copyright
        'footer_copyright_text' => esc_html__('Copyright © 2020 Organium by Artureanec. All Rights Reserved.', 'organium'),

        # Footer Menu
        'footer_menu_status' => 'show',

        # Footer Additional Menu
        'footer_additional_menu_status' => 'show',

        # Footer Socials
        'footer_socials_status' => 'hide',
        'footer_socials_font_size' => '13px',
        'footer_socials_type' => 'bg',

        # Footer Payment Image
        'footer_payment_status' => 'hide',
        'footer_payment_image' => '',

        # Footer Subscribe Form
        'footer_subscribe_status' => 'hide',
        'footer_subscribe_title' => '',
        'footer_subscribe_text' => '',
        'footer_subscribe_shortcode' => '',

    # Page Title
        'page_title_status' => 'show',
        'title_height' => '449',
        'title_additional_text' => 'organic',
        'post_title_bg' => '',

    # Content
        'content_top_margin' => 'yes',
        'content_bottom_margin' => 'yes',
        'page_loader' => 'on',

    # Sidebars
        'sidebar_name'                  => 'sidebar',
        'sidebar_position'              => 'right',
        'archive_sidebar_position'      => 'right',
        'post_sidebar_position'         => 'right',
        'portfolio_sidebar_position'    => 'none',
        'recipe_sidebar_position'       => 'right',
        'catalog_sidebar_position'      => 'none',

    # Single Post
        'media_output_status' => 'show',
        'post_meta_status' => 'show',
        'after_content_panel_status' => 'show',
        'comments_status' => 'show',

        'recent_posts_status' => 'hide',
        'recent_posts_number' => '3',
        'recent_posts_order_by' => 'random',
        'recent_posts_order' => 'desc',
        'recent_posts_image' => 'show',
        'recent_posts_category' => 'show',
        'recent_posts_title' => 'show',
        'recent_posts_date' => 'show',
        'recent_posts_author' => 'show',
        'recent_posts_excerpt' => 'show',
        'recent_posts_excerpt_length' => '120',
        'recent_posts_tags' => 'hide',
        'recent_posts_more' => 'show',

    # 404 Error
        '404_bg_image' => get_template_directory_uri() . '/img/404-bg.jpg',
        '404_bg_color' => '#eae9e4',
        '404_title' => '',
        '404_text' => '',
        '404_button_text' => esc_html__('Home Page', 'organium')
);

if (!function_exists('organium_sanitize_callback_with_tags')) {
    function organium_sanitize_callback_with_tags($input) {
        return $input;
    }
}

# Register Customizer
add_action('customize_register', 'organium_customizer_register');
if (!function_exists('organium_customizer_register')) {
    function organium_customizer_register($wp_customize) {
        global $organium_customizer_default_values;

        // ------------------------------------------- //
        // ---------- Header Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('organium_header_settings',
            array(
                'title' => esc_html__('Header Settings', 'organium'),
                'priority' => 130
            )
        );

            // ---######################--- //
            // ---### Header General ###--- //
            // ---######################--- //
            $wp_customize->add_section('organium_header_general',
                array(
                    'title' => esc_html__('General', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // ------------------- //
                // --- Header Type --- //
                // ------------------- //
                $wp_setting_name = 'header_style';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Style', 'organium'),
                        'section' => 'organium_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'type_1' => esc_html__('Style Type 1', 'organium'),
                            'type_2' => esc_html__('Style Type 2', 'organium'),
                            'type_3' => esc_html__('Style Type 3', 'organium')
                        ),
                    )
                ));

                // ----------------------- //
                // --- Header Position --- //
                // ----------------------- //
                $wp_setting_name = 'header_position';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Position', 'organium'),
                        'section' => 'organium_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'above' => esc_html__('Above', 'organium'),
                            'over' => esc_html__('Over', 'organium')
                        )
                    )
                ));

                // --------------------- //
                // --- Sticky Header --- //
                // --------------------- //
                $wp_setting_name = 'sticky_header';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sticky Header', 'organium'),
                        'section' => 'organium_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));


            // ---#####################--- //
            // ---### Logo Settings ###--- //
            // ---#####################--- //
            $wp_customize->add_section('organium_header_logo',
                array(
                    'title' => esc_html__('Logo', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // ------------------- //
                // --- Header Logo --- //
                // ------------------- //
                $wp_setting_name = 'logo_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Logo Image', 'organium'),
                        'section' => 'organium_header_logo',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------- //
                // --- Logo Retina --- //
                // ------------------- //
                $wp_setting_name = 'logo_retina';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Logo Retina', 'organium'),
                        'section' => 'organium_header_logo',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));



            // ---#############################--- //
            // ---### Header Social Buttons ###--- //
            // ---#############################--- //
            $wp_customize->add_section('organium_header_socials',
                array(
                    'title' => esc_html__('Social Buttons Settings', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );
                // ----------------------------- //
                // --- Header Social Buttons --- //
                // ----------------------------- //
                $wp_setting_name = 'header_socials';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Social Buttons', 'organium'),
                        'section' => 'organium_header_socials',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));

                // --------------------------- //
                // --- Header Socials Type --- //
                // --------------------------- //
                $wp_setting_name = 'header_socials_type';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Socials Type', 'organium'),
                        'section' => 'organium_header_socials',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="header_socials" data-dependency-val="on"></i>',
                        'type' => 'select',
                        'choices' => array(
                            'bg'    => esc_html__('Icon With Background', 'organium'),
                            'nobg'  => esc_html__('Icon Without Background', 'organium')
                        )
                    )
                ));

                // --------------------------- //
                // --- Header Socials Size --- //
                // --------------------------- //
                $wp_setting_name = 'header_socials_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Socials Size', 'organium'),
                        'section' => 'organium_header_socials',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="header_socials" data-dependency-val="on"></i>'
                    )
                ));

            // ---#####################--- //
            // ---### Header Button ###--- //
            // ---#####################--- //
            $wp_customize->add_section('organium_header_button',
                array(
                    'title' => esc_html__('Header Button Settings', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // --------------------- //
                // --- Header Button --- //
                // --------------------- //
                $wp_setting_name = 'header_button';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Button', 'organium'),
                        'section' => 'organium_header_button',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));

                // -------------------------- //
                // --- Header Button Text --- //
                // -------------------------- //
                $wp_setting_name = 'header_button_text';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Button Text', 'organium'),
                        'section' => 'organium_header_button',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="header_button" data-dependency-val="on"></i>'
                    )
                ));

                // -------------------------- //
                // --- Header Button URL ---- //
                // -------------------------- //
                $wp_setting_name = 'header_button_url';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Button Link', 'organium'),
                        'section' => 'organium_header_button',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="header_button" data-dependency-val="on"></i>'
                    )
                ));

            // ---#####################--- //
            // ---### Menu Settings ###--- //
            // ---#####################--- //
            $wp_customize->add_section('organium_header_menu',
                array(
                    'title' => esc_html__('Menu', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // ------------------------ //
                // --- Menu Font Family --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Font Family', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------- //
                // --- Menu Font Size --- //
                // ---------------------- //
                $wp_setting_name = 'header_menu_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Font Size', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Menu Line Height --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Line Height', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Menu Font Weight --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Font Weight', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html__('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

                // ---------------------- //
                // --- Menu Uppercase --- //
                // ---------------------- //
                $wp_setting_name = 'header_menu_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Uppercase', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ------------------- //
                // --- Menu Italic --- //
                // ------------------- //
                $wp_setting_name = 'header_menu_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Italic', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Font Family --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Font Family', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // -------------------------- //
                // --- Sub Menu Font Size --- //
                // -------------------------- //
                $wp_setting_name = 'header_sub_menu_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Font Size', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Line Height --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Line Height', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Font Weight --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Font Weight', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html__('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

                // -------------------------- //
                // --- Sub Menu Uppercase --- //
                // -------------------------- //
                $wp_setting_name = 'header_sub_menu_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Uppercase', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ----------------------- //
                // --- Sub Menu Italic --- //
                // ----------------------- //
                $wp_setting_name = 'header_sub_menu_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sub Menu Italic', 'organium'),
                        'section' => 'organium_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));


            // ---###########################--- //
            // ---### Side Panel Settings ###--- //
            // ---###########################--- //
            $wp_customize->add_section('organium_side_panel',
                array(
                    'title' => esc_html__('Side Panel', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // ------------------ //
                // --- Side Panel --- //
                // ------------------ //
                $wp_setting_name = 'side_panel';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Side Panel', 'organium'),
                        'section' => 'organium_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));

                // ------------------------------- //
                // --- Side Panel Trigger Type --- //
                // ------------------------------- //
                $wp_setting_name = 'side_panel_trigger_type';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Side Panel Trigger Type', 'organium'),
                        'section' => 'organium_side_panel',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="side_panel" data-dependency-val="on"></i>',
                        'type' => 'select',
                        'choices' => array(
                            'large' => esc_html__('Large', 'organium'),
                            'small' => esc_html__('Small', 'organium')
                        )
                    )
                ));

            // ---#####################--- //
            // ---### Header Search ###--- //
            // ---#####################--- //
            $wp_customize->add_section('organium_header_search',
                array(
                    'title' => esc_html__('Header Search Settings', 'organium'),
                    'panel' => 'organium_header_settings'
                )
            );

                // --------------------- //
                // --- Header Search --- //
                // --------------------- //
                $wp_setting_name = 'header_search';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Search', 'organium'),
                        'section' => 'organium_header_search',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));


            if ( class_exists('WooCommerce')) {
                // ---########################--- //
                // ---### Header Mini Cart ###--- //
                // ---########################--- //
                $wp_customize->add_section('organium_header_minicart',
                    array(
                        'title' => esc_html__('Header Mini Cart', 'organium'),
                        'panel' => 'organium_header_settings'
                    )
                );

                    // ------------------------ //
                    // --- Header Mini Cart --- //
                    // ------------------------ //
                    $wp_setting_name = 'header_minicart';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Mini Cart', 'organium'),
                            'section' => 'organium_header_minicart',
                            'settings' => $wp_setting_name,
                            'type' => 'select',
                            'choices' => array(
                                'on' => esc_html__('On', 'organium'),
                                'off' => esc_html__('Off', 'organium')
                            )
                        )
                    ));

                // ---#######################--- //
                // ---### Header Wishlist ###--- //
                // ---#######################--- //
                $wp_customize->add_section('organium_header_wishlist',
                    array(
                        'title' => esc_html__('Header Wishlist', 'organium'),
                        'panel' => 'organium_header_settings'
                    )
                );

                // --------------------- //
                // --- Header Button --- //
                // --------------------- //
                $wp_setting_name = 'header_wishlist';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Wishlist', 'organium'),
                        'section' => 'organium_header_wishlist',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'organium'),
                            'off' => esc_html__('Off', 'organium')
                        )
                    )
                ));
            }


        // -------------------------------- //
        // ---------- Typography ---------- //
        // -------------------------------- //
        $wp_customize->add_panel('organium_typography_settings',
            array(
                'title' => esc_html__('Typography Settings', 'organium'),
                'priority' => 140
            )
        );

            // ---#################--- //
            // ---### Main Font ###--- //
            // ---#################--- //
            $wp_customize->add_section('organium_typography_main_font',
                array(
                    'title' => esc_html__('Main Font', 'organium'),
                    'panel' => 'organium_typography_settings'
                )
            );

                // ------------------------ //
                // --- Main Font Family --- //
                // ------------------------ //
                $wp_setting_name = 'main_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Main Font Family', 'organium'),
                        'section' => 'organium_typography_main_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------- //
                // --- Main Font Size --- //
                // ---------------------- //
                $wp_setting_name = 'main_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Main Font Size', 'organium'),
                        'section' => 'organium_typography_main_font',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Main Font Line Height --- //
                // ----------------------------- //
                $wp_setting_name = 'main_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Main Font Line Height', 'organium'),
                        'section' => 'organium_typography_main_font',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Main Font Weight --- //
                // ------------------------ //
                $wp_setting_name = 'main_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Main Font Weight', 'organium'),
                        'section' => 'organium_typography_main_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

            // ---#######################--- //
            // ---### Additional Font ###--- //
            // ---#######################--- //
            $wp_customize->add_section('organium_typography_additional_font',
                array(
                    'title' => esc_html__('Additional Font', 'organium'),
                    'panel' => 'organium_typography_settings'
                )
            );

                // ------------------------------ //
                // --- Additional Font Family --- //
                // ------------------------------ //
                $wp_setting_name = 'additional_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Additional Font Family', 'organium'),
                        'section' => 'organium_typography_additional_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ------------------------------ //
                // --- Additional Font Weight --- //
                // ------------------------------ //
                $wp_setting_name = 'additional_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Additional Font Weight', 'organium'),
                        'section' => 'organium_typography_additional_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html__('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

            // ---################--- //
            // ---### Headings ###--- //
            // ---################--- //
            $wp_customize->add_section('organium_typography_headings',
                array(
                    'title' => esc_html__('Headings', 'organium'),
                    'panel' => 'organium_typography_settings'
                )
            );

                // ---------------------------- //
                // --- Headings Font Family --- //
                // ---------------------------- //
                $wp_setting_name = 'headings_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Headings Font Family', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Headings Font Weight --- //
                // ---------------------------- //
                $wp_setting_name = 'headings_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Headings Font Weight', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html__('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

                // -------------------------- //
                // --- Headings Uppercase --- //
                // -------------------------- //
                $wp_setting_name = 'headings_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Headings Uppercase', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ----------------------- //
                // --- Headings Italic --- //
                // ----------------------- //
                $wp_setting_name = 'headings_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Headings Italic', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // -------------------- //
                // --- H1 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h1_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H1 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H1 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h1_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H1 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H2 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h2_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H2 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H2 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h2_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H2 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H3 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h3_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H3 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H3 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h3_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H3 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H4 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h4_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H4 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H4 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h4_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H4 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H5 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h5_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H5 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H5 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h5_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H5 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H6 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h6_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H6 Font Size', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H6 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h6_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('H6 Line Height', 'organium'),
                        'section' => 'organium_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---###############--- //
            // ---### Buttons ###--- //
            // ---###############--- //
            $wp_customize->add_section('organium_typography_buttons',
                array(
                    'title' => esc_html__('Buttons', 'organium'),
                    'panel' => 'organium_typography_settings'
                )
            );

                // --------------------------- //
                // --- Buttons Font Family --- //
                // --------------------------- //
                $wp_setting_name = 'buttons_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Buttons Font Family', 'organium'),
                        'section' => 'organium_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ------------------------- //
                // --- Buttons Font Size --- //
                // ------------------------- //
                $wp_setting_name = 'buttons_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Buttons Font Size', 'organium'),
                        'section' => 'organium_typography_buttons',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Buttons Font Weight --- //
                // --------------------------- //
                $wp_setting_name = 'buttons_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Buttons Font Weight', 'organium'),
                        'section' => 'organium_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => esc_html__('Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.', 'organium'),
                        'choices' => array(
                            '100' => esc_html__('100', 'organium'),
                            '200' => esc_html__('200', 'organium'),
                            '300' => esc_html__('300', 'organium'),
                            '400' => esc_html__('400', 'organium'),
                            '500' => esc_html__('500', 'organium'),
                            '600' => esc_html__('600', 'organium'),
                            '700' => esc_html__('700', 'organium'),
                            '800' => esc_html__('800', 'organium'),
                            '900' => esc_html__('900', 'organium')
                        )
                    )
                ));

                // ------------------------- //
                // --- Buttons Uppercase --- //
                // ------------------------- //
                $wp_setting_name = 'buttons_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Buttons Uppercase', 'organium'),
                        'section' => 'organium_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ---------------------- //
                // --- Buttons Italic --- //
                // ---------------------- //
                $wp_setting_name = 'buttons_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Buttons Italic', 'organium'),
                        'section' => 'organium_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

            // ---##################--- //
            // ---### Page Title ###--- //
            // ---##################--- //
            $wp_customize->add_section('organium_typography_page_title',
                array(
                    'title' => esc_html__('Page Title', 'organium'),
                    'panel' => 'organium_typography_settings'
                )
            );

                // ------------------------------ //
                // --- Site Title Font Family --- //
                // ------------------------------ //
                $wp_setting_name = 'site_title_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Site Title Font Family', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Site Title Font Size --- //
                // ---------------------------- //
                $wp_setting_name = 'site_title_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Site Title Font Size', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Page Title Font Family --- //
                // ------------------------------ //
                $wp_setting_name = 'page_title_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Page Title Font Family', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Page Title Font Size --- //
                // ---------------------------- //
                $wp_setting_name = 'page_title_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Page Title Font Size', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------------ //
                // --- Header Additional Test Font Family --- //
                // ------------------------------------------ //
                $wp_setting_name = 'title_additional_text_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Additional Text Font Family', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => organium_get_all_fonts_name(),
                    )
                ));

                // ---------------------------------------- //
                // --- Header Additional Text Font Size --- //
                // ---------------------------------------- //
                $wp_setting_name = 'title_additional_text_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Header Additional Text Font Size', 'organium'),
                        'section' => 'organium_typography_page_title',
                        'settings' => $wp_setting_name,
                    )
                ));

        // ---------------------------------- //
        // ---------- Social Links ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('organium_socials_settings',
            array(
                'title' => esc_html__('Social Links', 'organium'),
                'priority' => 145
            )
        );

            // ---------------------- //
            // --- Socials Target --- //
            // ---------------------- //
            $wp_setting_name = 'socials_target';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Open Socials in New Tab', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'checkbox',
                )
            ));

            // ---------------- //
            // --- Facebook --- //
            // ---------------- //
            $wp_setting_name = 'socials_facebook';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Facebook', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // --------------- //
            // --- Twitter --- //
            // --------------- //
            $wp_setting_name = 'socials_twitter';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Twitter', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------------- //
            // --- LinkedIn --- //
            // ---------------- //
            $wp_setting_name = 'socials_linkedin';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('LinkedIn', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // --------------- //
            // --- YouTube --- //
            // --------------- //
            $wp_setting_name = 'socials_youtube';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('YouTube', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ----------------- //
            // --- Instagram --- //
            // ----------------- //
            $wp_setting_name = 'socials_instagram';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Instagram', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ----------------- //
            // --- Pinterest --- //
            // ----------------- //
            $wp_setting_name = 'socials_pinterest';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Pinterest', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // -------------- //
            // --- Tumblr --- //
            // -------------- //
            $wp_setting_name = 'socials_tumbl';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Tumblr', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // -------------- //
            // --- Flickr --- //
            // -------------- //
            $wp_setting_name = 'socials_flickr';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Flickr', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------- //
            // --- VK --- //
            // ---------- //
            $wp_setting_name = 'socials_vk';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('VK', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------------- //
            // --- Dribbble --- //
            // ---------------- //
            $wp_setting_name = 'socials_dribbble';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Dribbble', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------- //
            // --- Vimeo --- //
            // ------------- //
            $wp_setting_name = 'socials_vimeo';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Vimeo', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------- //
            // --- 500px --- //
            // ------------- //
            $wp_setting_name = 'socials_500px';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('500px', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------ //
            // --- XING --- //
            // ------------ //
            $wp_setting_name = 'socials_xing';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Xing', 'organium'),
                    'section' => 'organium_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

        // ------------------------------------ //
        // ---------- Color Settings ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('organium_color_settings',
            array(
                'title' => esc_html__('Color Settings', 'organium'),
                'priority' => 150
            )
        );

            // ---###############--- //
            // ---### General ###--- //
            // ---###############--- //
            $wp_customize->add_section('organium_general_colors',
                array(
                    'title' => esc_html__('General', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ----------------------- //
                // --- Site Background --- //
                // ----------------------- //
                $wp_setting_name = 'site_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Site Background', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Site Main Color --- //
                // ----------------------- //
                $wp_setting_name = 'main_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Site Main Color', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Site Accent Color --- //
                // ----------------------- //
                $wp_setting_name = 'accent_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Site Accent Color', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Main Font Color --- //
                // ----------------------- //
                $wp_setting_name = 'main_font_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Main Font Color', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- Headings Color --- //
                // ---------------------- //
                $wp_setting_name = 'headings_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Headings Color', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Listing Titles Color --- //
                // ---------------------------- //
                $wp_setting_name = 'listing_titles_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Listing Titles Color', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Listing Titles Hover --- //
                // ---------------------------- //
                $wp_setting_name = 'listing_titles_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Listing Titles Hover', 'organium'),
                        'section' => 'organium_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##################--- //
            // ---### Side Panel ###--- //
            // ---##################--- //
            $wp_customize->add_section('organium_side_panel_colors',
                array(
                    'title' => esc_html__('Side Panel', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ----------------------------- //
                // --- Side Panel Background --- //
                // ----------------------------- //
                $wp_setting_name = 'side_panel_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Side Panel Background', 'organium'),
                        'section' => 'organium_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Close Button Color --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_close_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Close Button Color', 'organium'),
                        'section' => 'organium_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Close Button Hover --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_close_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Close Button Hover', 'organium'),
                        'section' => 'organium_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##############--- //
            // ---### Header ###--- //
            // ---##############--- //
            $wp_customize->add_section('organium_header_colors',
                array(
                    'title' => esc_html__('Header', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ---######################--- //
                // ---### Header General ###--- //
                // ---######################--- //

                    // --- Header Background --- //
                    $wp_setting_name = 'header_bg';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Background', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Border --- //
                    $wp_setting_name = 'header_bd';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Border', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---############--- //
                // ---### Logo ###--- //
                // ---############--- //

                    // --- Header Logo --- //
                    $wp_setting_name = 'header_logo_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Logo Text', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---#############################--- //
                // ---### Header Social Buttons ###--- //
                // ---#############################--- //

                    // --- Header Social Button Icon Color --- //
                    $wp_setting_name = 'header_socials_icon_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Social Buttons Icon Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Social Button Icon Hover --- //
                    $wp_setting_name = 'header_socials_icon_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Social Buttons Icon Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Social Button Background Color --- //
                    $wp_setting_name = 'header_socials_bg_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Social Buttons Background Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Social Button Background Hover --- //
                    $wp_setting_name = 'header_socials_bg_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Social Buttons Background Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---#####################--- //
                // ---### Header Button ###--- //
                // ---#####################--- //

                    // --- Header Button Color --- //
                    $wp_setting_name = 'header_button_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Button Text Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Button Hover --- //
                    $wp_setting_name = 'header_button_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Button Text Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Button BG Color --- //
                    $wp_setting_name = 'header_button_bg_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Button Background Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Button BG Hover --- //
                    $wp_setting_name = 'header_button_bg_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Button Background Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---###################--- //
                // ---### Header Menu ###--- //
                // ---###################--- //

                    // --- Header Menu Color --- //
                    $wp_setting_name = 'header_menu_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Menu Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Menu Hover --- //
                    $wp_setting_name = 'header_menu_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Menu Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Sub Menu Color --- //
                    $wp_setting_name = 'header_sub_menu_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Sub Menu Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Sub Menu Hover --- //
                    $wp_setting_name = 'header_sub_menu_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Sub Menu Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Sub Menu Background --- //
                    $wp_setting_name = 'header_sub_menu_bg';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Sub Menu Background', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---##########################--- //
                // ---### Side Panel Trigger ###--- //
                // ---##########################--- //

                    // --- Side Panel Trigger Color --- //
                    $wp_setting_name = 'side_panel_trigger_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Side Panel Trigger Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Side Panel Trigger Hover --- //
                    $wp_setting_name = 'side_panel_trigger_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Side Panel Trigger Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Side Panel Trigger BG Color --- //
                    $wp_setting_name = 'side_panel_trigger_bg_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Side Panel Trigger Background Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Side Panel Trigger BG Hover --- //
                    $wp_setting_name = 'side_panel_trigger_bg_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Side Panel Trigger Background Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---#####################--- //
                // ---### Header Search ###--- //
                // ---#####################--- //

                    // --- Header Search Trigger Color --- //
                    $wp_setting_name = 'header_search_trigger_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Search Trigger Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Search Trigger Hover --- //
                    $wp_setting_name = 'header_search_trigger_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Search Trigger Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

            if ( class_exists('WooCommerce')) {
                // ---########################--- //
                // ---### Header Mini Cart ###--- //
                // ---########################--- //

                    // --- Header Minicart Icon Color --- //
                    $wp_setting_name = 'header_minicart_icon_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Icon Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Minicart Icon Hover --- //
                    $wp_setting_name = 'header_minicart_icon_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Icon Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Minicart BG Color --- //
                    $wp_setting_name = 'header_minicart_bg_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Background Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Minicart BG Hover --- //
                    $wp_setting_name = 'header_minicart_bg_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Background Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Minicart Counter Color --- //
                    $wp_setting_name = 'header_minicart_counter_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Counter Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Minicart Counter Background --- //
                    $wp_setting_name = 'header_minicart_counter_bg';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Minicart Counter Background', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                // ---#######################--- //
                // ---### Header Wishlist ###--- //
                // ---#######################--- //

                    // --- Header Wishlist Link Color --- //
                    $wp_setting_name = 'header_wishlist_color';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Wishlist Link Color', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));

                    // --- Header Wishlist Link Hover --- //
                    $wp_setting_name = 'header_wishlist_hover';
                    $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                    $wp_customize->add_control(new WP_Customize_Color_Control(
                        $wp_customize,
                        $wp_setting_name,
                        array(
                            'label' => esc_html__('Header Wishlist Link Hover', 'organium'),
                            'section' => 'organium_header_colors',
                            'settings' => $wp_setting_name,
                        )
                    ));
            }










            // ---###############--- //
            // ---### Buttons ###--- //
            // ---###############--- //
            $wp_customize->add_section('organium_buttons_colors',
                array(
                    'title' => esc_html__('Buttons', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // -------------------- //
                // --- Button Color --- //
                // -------------------- //
                $wp_setting_name = 'button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Button Color', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- Button Hover --- //
                // -------------------- //
                $wp_setting_name = 'button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Button Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Button Background --- //
                // ------------------------- //
                $wp_setting_name = 'button_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Button Background', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Button Background Hover --- //
                // ------------------------------- //
                $wp_setting_name = 'button_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Button Background Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Button Alter Color --- //
                // -------------------------- //
                $wp_setting_name = 'button_alter_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Alternate Button Color', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Button Alter Hover --- //
                // -------------------------- //
                $wp_setting_name = 'button_alter_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Alternate Button Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Button Alter Background --- //
                // ------------------------------- //
                $wp_setting_name = 'button_alter_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Alternate Button Background', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------- //
                // --- Button Alter Background Hover --- //
                // ------------------------------------- //
                $wp_setting_name = 'button_alter_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Alternate Button Background Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------------- //
                // --- Post Social Buttons Color --- //
                // --------------------------------- //
                $wp_setting_name = 'post_socials_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Post Social Buttons Color', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------------- //
                // --- Post Social Buttons Hover --- //
                // --------------------------------- //
                $wp_setting_name = 'post_socials_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Post Social Buttons Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------------- //
                // --- Post Social Buttons Background --- //
                // -------------------------------------- //
                $wp_setting_name = 'post_socials_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Post Social Buttons Background', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------------------- //
                // --- Post Social Buttons Background Hover --- //
                // -------------------------------------------- //
                $wp_setting_name = 'post_socials_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Post Social Buttons Background Hover', 'organium'),
                        'section' => 'organium_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##############--- //
            // ---### Footer ###--- //
            // ---##############--- //
            $wp_customize->add_section('organium_footer_colors',
                array(
                    'title' => esc_html__('Footer', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ------------------------------- //
                // --- Footer Background Color --- //
                // ------------------------------- //
                $wp_setting_name = 'footer_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Background Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Footer Text Color --- //
                // ------------------------- //
                $wp_setting_name = 'footer_text_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Text Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Footer Text Accent Color --- //
                // -------------------------------- //
                $wp_setting_name = 'footer_accent_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Text Accent Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Footer Text Hover Color --- //
                // ------------------------------- //
                $wp_setting_name = 'footer_hover_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Text Hover Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Footer Logo Text Color --- //
                // ------------------------------ //
                $wp_setting_name = 'footer_logo_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Logo Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------------- //
                // --- Footer Sidebar Text Color --- //
                // --------------------------------- //
                $wp_setting_name = 'footer_sidebar_text_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Widgets Text Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------------- //
                // --- Footer Sidebar Accent Color --- //
                // ----------------------------------- //
                $wp_setting_name = 'footer_sidebar_accent_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Widgets Accent Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------------- //
                // --- Footer Sidebar Hover Color --- //
                // ----------------------------------- //
                $wp_setting_name = 'footer_sidebar_hover_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Widgets Hover Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Footer Menu Link Color --- //
                // ------------------------------ //
                $wp_setting_name = 'footer_menu_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Menu Link Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Footer Menu Hover Color --- //
                // ------------------------------- //
                $wp_setting_name = 'footer_menu_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Menu Link Hover', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Footer Menu Border Color --- //
                // ------------------------------- //
                $wp_setting_name = 'footer_menu_border_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Menu Border Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Footer Social Icon Hover --- //
                // -------------------------------- //
                $wp_setting_name = 'footer_socials_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Social Icons Hover', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------------- //
                // --- Footer Social Icon BG Color --- //
                // ----------------------------------- //
                $wp_setting_name = 'footer_socials_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Social Icons Background Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------------- //
                // --- Footer Social Icon BG Hover --- //
                // ----------------------------------- //
                $wp_setting_name = 'footer_socials_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Social Icons Background Hover', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Footer Button Text Color --- //
                // -------------------------------- //
                $wp_setting_name = 'footer_button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Button Text Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Footer Button Text Hover --- //
                // -------------------------------- //
                $wp_setting_name = 'footer_button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Button Text Hover', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------------- //
                // --- Footer Button Shadow Color --- //
                // ---------------------------------- //
                $wp_setting_name = 'footer_button_shadow';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Button Shadow Color', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------------- //
                // --- Footer Button Hover Shadow --- //
                // ---------------------------------- //
                $wp_setting_name = 'footer_button_hover_shadow';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Hover Button Shadow', 'organium'),
                        'section' => 'organium_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));



            // ---##################--- //
            // ---### Page Title ###--- //
            // ---##################--- //
            $wp_customize->add_section('organium_page_title_colors',
                array(
                    'title' => esc_html__('Page Title', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ----------------------------- //
                // --- Page Title Background --- //
                // ----------------------------- //
                $wp_setting_name = 'post_title_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Page Title Background Color', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Page Title Color --- //
                // ------------------------ //
                $wp_setting_name = 'page_title_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Page Title Color', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------------------- //
                // --- Page Title Additional Text Color --- //
                // ---------------------------------------- //
                $wp_setting_name = 'title_additional_text_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Page Title Additional Text Color', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Breadcrumbs Text Color --- //
                // ------------------------------ //
                $wp_setting_name = 'breadcrumbs_text_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Breadcrumbs Text Color', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Breadcrumbs Link Color --- //
                // ------------------------------ //
                $wp_setting_name = 'breadcrumbs_link_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Breadcrumbs Link Color', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Breadcrumbs Link Hover --- //
                // ------------------------------ //
                $wp_setting_name = 'breadcrumbs_link_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Breadcrumbs Link Hover', 'organium'),
                        'section' => 'organium_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---#############--- //
            // ---### Forms ###--- //
            // ---#############--- //
            $wp_customize->add_section('organium_form_colors',
                array(
                    'title' => esc_html__('Forms', 'organium'),
                    'panel' => 'organium_color_settings'
                )
            );

                // ------------------------ //
                // --- Form Field Color --- //
                // ------------------------ //
                $wp_setting_name = 'form_field_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Field Color', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Form Field Background --- //
                // ----------------------------- //
                $wp_setting_name = 'form_field_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Field Background', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Field Border --- //
                // ------------------------- //
                $wp_setting_name = 'form_field_border';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Field Border', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------ //
                // --- Active Form Field Background --- //
                // ------------------------------------ //
                $wp_setting_name = 'active_form_field_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Active Form Field Background', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Active Form Field Border --- //
                // -------------------------------- //
                $wp_setting_name = 'active_form_field_border';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Active Form Field Border', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Button Color --- //
                // ------------------------- //
                $wp_setting_name = 'form_button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Button Color', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Button Hover --- //
                // ------------------------- //
                $wp_setting_name = 'form_button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Button Hover', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Form Button Background --- //
                // ------------------------------ //
                $wp_setting_name = 'form_button_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Button Background', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------ //
                // --- Form Button Background Hover --- //
                // ------------------------------------ //
                $wp_setting_name = 'form_button_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Form Button Background Hover', 'organium'),
                        'section' => 'organium_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

        // ------------------------------------------- //
        // ---------- Footer Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('organium_footer_settings',
            array(
                'title' => esc_html__('Footer Settings', 'organium'),
                'priority' => 160
            )
        );

            // ---###############--- //
            // ---### General ###--- //
            // ---###############--- //
            $wp_customize->add_section('organium_footer_general',
                array(
                    'title' => esc_html__('General', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // --------------------- //
                // --- Footer Status --- //
                // --------------------- //
                $wp_setting_name = 'footer_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

                // -------------------- //
                // --- Footer Style --- //
                // -------------------- //
                $wp_setting_name = 'footer_style';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Style', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'style_1' => esc_html__('Style 1', 'organium'),
                            'style_2' => esc_html__('Style 2', 'organium'),
                            'style_3' => esc_html__('Style 3', 'organium'),
                            'style_4' => esc_html__('Style 4', 'organium'),
                        ),
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_status" data-dependency-val="show"></i>'
                    )
                ));

                // ------------------------- //
                // --- Footer Background --- //
                // ------------------------- //
                $wp_setting_name = 'footer_bg_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Bottom Image', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_status" data-dependency-val="show"></i>'
                    )
                ));

                // ---------------------------------- //
                // --- Footer Background Position --- //
                // ---------------------------------- //
                $wp_setting_name = 'footer_bg_position';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Background Position', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'center center' => esc_html__('Center Center', 'organium'),
                            'center left' => esc_html__('Center Left', 'organium'),
                            'center right' => esc_html__('Center Right', 'organium'),
                            'top center' => esc_html__('Top Center', 'organium'),
                            'top left' => esc_html__('Top Left', 'organium'),
                            'top right' => esc_html__('Top Right', 'organium'),
                            'bottom center' => esc_html__('Bottom Center', 'organium'),
                            'bottom left' => esc_html__('Bottom Left', 'organium'),
                            'bottom right' => esc_html__('Bottom Right', 'organium'),
                        ),
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_status" data-dependency-val="show"></i>'
                    )
                ));

                // ---------------------------------- //
                // --- Footer Background Repeat --- //
                // ---------------------------------- //
                $wp_setting_name = 'footer_bg_repeat';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Background Repeat', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'no-repeat' => esc_html__('No-repeat', 'organium'),
                            'repeat' => esc_html__('Repeat', 'organium'),
                            'repeat-x' => esc_html__('Repeat-x', 'organium'),
                            'repeat-y' => esc_html__('Repeat-y', 'organium'),
                        ),
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_status" data-dependency-val="show"></i>'
                    )
                ));

                // ------------------------------ //
                // --- Footer Background Size --- //
                // ------------------------------ //
                $wp_setting_name = 'footer_bg_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Background Size', 'organium'),
                        'section' => 'organium_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'initial' => esc_html__('Default', 'organium'),
                            'auto' => esc_html__('Auto', 'organium'),
                            'cover' => esc_html__('Cover', 'organium'),
                            'contain' => esc_html__('Contain', 'organium'),
                        ),
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_status" data-dependency-val="show"></i>'
                    )
                ));


            // ---############--- //
            // ---### Logo ###--- //
            // ---############--- //
            $wp_customize->add_section('organium_footer_logo',
                array(
                    'title' => esc_html__('Footer Logo', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // -------------------------- //
                // --- Footer Logo Status --- //
                // -------------------------- //
                $wp_setting_name = 'footer_logo_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Logo Status', 'organium'),
                        'section' => 'organium_footer_logo',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

                // ------------------- //
                // --- Footer Logo --- //
                // ------------------- //
                $wp_setting_name = 'footer_logo_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Logo Image', 'organium'),
                        'section' => 'organium_footer_logo',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_logo_status" data-dependency-val="show"></i>'
                    )
                ));

                // -------------------------- //
                // --- Footer Logo Retina --- //
                // -------------------------- //
                $wp_setting_name = 'footer_logo_retina';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Logo Retina', 'organium'),
                        'section' => 'organium_footer_logo',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox',
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_logo_status" data-dependency-val="show"></i>'
                    )
                ));


            // ---######################--- //
            // ---### Footer Sidebar ###--- //
            // ---######################--- //
            $wp_customize->add_section('organium_footer_sidebar',
                array(
                    'title' => esc_html__('Footer Sidebar', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // ----------------------------- //
                // --- Footer Sidebar Status --- //
                // ----------------------------- //
                $wp_setting_name = 'footer_sidebar_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Sidebar Status', 'organium'),
                        'section' => 'organium_footer_sidebar',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

                // ----------------------------- //
                // --- Footer Sidebar Select --- //
                // ----------------------------- //
                $sidebar_list = array();
                foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
                    $sidebar_list[$sidebar['id']] = $sidebar['name'];
                }
                $wp_setting_name = 'footer_sidebar_select';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Select Sidebar', 'organium'),
                        'section' => 'organium_footer_sidebar',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => $sidebar_list,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_sidebar_status" data-dependency-val="show"></i>'
                    )
                ));


            // ---#################--- //
            // ---### Copyright ###--- //
            // ---#################--- //
            $wp_customize->add_section('organium_footer_copyright',
                array(
                    'title' => esc_html__('Copyright', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // ---------------------- //
                // --- Copyright Text --- //
                // ---------------------- //
                $wp_setting_name = 'footer_copyright_text';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Copyright Text', 'organium'),
                        'section' => 'organium_footer_copyright',
                        'settings' => $wp_setting_name
                    )
                ));

            // ---###################--- //
            // ---### Footer Menu ###--- //
            // ---###################--- //
            $wp_customize->add_section('organium_footer_menu',
                array(
                    'title' => esc_html__('Footer Menu', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // -------------------------- //
                // --- Footer Menu Status --- //
                // -------------------------- //
                $wp_setting_name = 'footer_menu_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Status', 'organium'),
                        'section' => 'organium_footer_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

            // ---##############################--- //
            // ---### Footer Additional Menu ###--- //
            // ---##############################--- //
            $wp_customize->add_section('organium_footer_additional_menu',
                array(
                    'title' => esc_html__('Footer Additional Menu', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // ----------------------------- //
                // --- Footer Sidebar Status --- //
                // ----------------------------- //
                $wp_setting_name = 'footer_additional_menu_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Menu Status', 'organium'),
                        'section' => 'organium_footer_additional_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));


            // ---#############################--- //
            // ---### Footer Social Buttons ###--- //
            // ---#############################--- //
            $wp_customize->add_section('organium_footer_socials',
                array(
                    'title' => esc_html__('Social Buttons Settings', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );
                // ----------------------------- //
                // --- Footer Social Buttons --- //
                // ----------------------------- //
                $wp_setting_name = 'footer_socials_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Social Buttons Status', 'organium'),
                        'section' => 'organium_footer_socials',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

                // --------------------------- //
                // --- Footer Socials Type --- //
                // --------------------------- //
                $wp_setting_name = 'footer_socials_type';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Social Buttons Type', 'organium'),
                        'section' => 'organium_footer_socials',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_socials_status" data-dependency-val="show"></i>',
                        'type' => 'select',
                        'choices' => array(
                            'bg'    => esc_html__('Icon With Background', 'organium'),
                            'nobg'  => esc_html__('Icon Without Background', 'organium')
                        )
                    )
                ));

                // --------------------------- //
                // --- Footer Socials Size --- //
                // --------------------------- //
                $wp_setting_name = 'footer_socials_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Social Buttons Size', 'organium'),
                        'section' => 'organium_footer_socials',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_socials_status" data-dependency-val="show"></i>'
                    )
                ));


            // ---#####################--- //
            // ---### Payment Image ###--- //
            // ---#####################--- //
            $wp_customize->add_section('organium_footer_payment',
                array(
                    'title' => esc_html__('Footer Payment Image', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // ---------------------------- //
                // --- Payment Image Status --- //
                // ---------------------------- //
                $wp_setting_name = 'footer_payment_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Payment Image Status', 'organium'),
                        'section' => 'organium_footer_payment',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'organium'),
                            'hide' => esc_html__('Hide', 'organium')
                        )
                    )
                ));

                // --------------------- //
                // --- Payment Image --- //
                // --------------------- //
                $wp_setting_name = 'footer_payment_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Payment Image', 'organium'),
                        'section' => 'organium_footer_payment',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="organium_dependency_customizer" data-dependency-id="footer_payment_status" data-dependency-val="show"></i>'
                    )
                ));

            // ---######################--- //
            // ---### Subscribe Form ###--- //
            // ---######################--- //
            $wp_customize->add_section('organium_footer_subscribe',
                array(
                    'title' => esc_html__('Footer Subscribe Form', 'organium'),
                    'panel' => 'organium_footer_settings'
                )
            );

                // ----------------------------- //
                // --- Subscribe Form Status --- //
                // ----------------------------- //
                $wp_setting_name = 'footer_subscribe_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Subscribe Form Status', 'organium'),
                        'section' => 'organium_footer_subscribe',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'hide' => esc_html__('Hide', 'organium'),
                            'show' => esc_html__('Show', 'organium')
                        )
                    )
                ));

                // ---------------------------- //
                // --- Subscribe Form Title --- //
                // ---------------------------- //
                $wp_setting_name = 'footer_subscribe_title';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Subscribe Title', 'organium'),
                        'section' => 'organium_footer_subscribe',
                        'settings' => $wp_setting_name
                    )
                ));

                // --------------------------- //
                // --- Subscribe Form Text --- //
                // --------------------------- //
                $wp_setting_name = 'footer_subscribe_text';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Subscribe Text', 'organium'),
                        'section' => 'organium_footer_subscribe',
                        'settings' => $wp_setting_name
                    )
                ));

                // -------------------------------- //
                // --- Subscribe Form Shortcode --- //
                // -------------------------------- //
                $wp_setting_name = 'footer_subscribe_shortcode';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Footer Subscribe Shortcode', 'organium'),
                        'section' => 'organium_footer_subscribe',
                        'settings' => $wp_setting_name
                    )
                ));


        // -------------------------------- //
        // ---------- Page Title ---------- //
        // -------------------------------- //
        $wp_customize->add_section('organium_page_title_settings',
            array(
                'title' => esc_html__('Page Title', 'organium'),
                'priority' => 170
            )
        );

            // ------------------- //
            // --- Page Title --- //
            // ------------------- //
            $wp_setting_name = 'page_title_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Page Title', 'organium'),
                    'section' => 'organium_page_title_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // ------------------------------- //
            // --- Page Title Block Height --- //
            // ------------------------------- //
            $wp_setting_name = 'title_height';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Page Title Height, px', 'organium'),
                    'section' => 'organium_page_title_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ----------------------------- //
            // --- Title Additional Text --- //
            // ----------------------------- //
            $wp_setting_name = 'title_additional_text';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Title Additional Text', 'organium'),
                    'section' => 'organium_page_title_settings',
                    'settings' => $wp_setting_name
                )
            ));

            // ----------------------------------------- //
            // --- Background Image (Selected Image) --- //
            // ----------------------------------------- //
            $wp_setting_name = 'post_title_bg';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Background Image', 'organium'),
                    'section' => 'organium_page_title_settings',
                    'settings' => $wp_setting_name,
                )
            ));

        // ---------------------------------- //
        // ---------- Page Content ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('organium_page_content_settings',
            array(
                'title' => esc_html__('Page Content', 'organium'),
                'priority' => 180
            )
        );

            $wp_setting_name = 'content_top_margin';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Content Top Margin', 'organium'),
                    'section' => 'organium_page_content_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'yes' => esc_html__('On', 'organium'),
                        'no' => esc_html__('Off', 'organium')
                    )
                )
            ));

            $wp_setting_name = 'content_bottom_margin';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Content Bottom Margin', 'organium'),
                    'section' => 'organium_page_content_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'yes' => esc_html__('On', 'organium'),
                        'no' => esc_html__('Off', 'organium')
                    )
                )
            ));

        // --------------------- //
        // --- Page Loader --- //
        // --------------------- //
        $wp_setting_name = 'page_loader';
        $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_html__('Header Loader', 'organium'),
                'section' => 'organium_page_content_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array(
                    'on' => esc_html__('On', 'organium'),
                    'off' => esc_html__('Off', 'organium')
                )
            )
        ));

        // ----------------------------------- //
        // ---------- Sidebar Title ---------- //
        // ----------------------------------- //
        $wp_customize->add_section('organium_sidebar_settings',
            array(
                'title' => esc_html__('Sidebars', 'organium'),
                'priority' => 190
            )
        );

            // ----------------------------- //
            // --- Page Sidebar Position --- //
            // ----------------------------- //
            $wp_setting_name = 'sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Page Sidebar Position', 'organium'),
                    'section' => 'organium_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'organium'),
                        'right' => esc_html__('Right', 'organium'),
                        'none' => esc_html__('None', 'organium')
                    )
                )
            ));

            // -------------------------------- //
            // --- Archive Sidebar Position --- //
            // -------------------------------- //
            $wp_setting_name = 'archive_sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Archive Sidebar Position', 'organium'),
                    'section' => 'organium_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'organium'),
                        'right' => esc_html__('Right', 'organium'),
                        'none' => esc_html__('None', 'organium')
                    )
                )
            ));

            // ------------------------------------ //
            // --- Single Post Sidebar Position --- //
            // ------------------------------------ //
            $wp_setting_name = 'post_sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Single Post Sidebar Position', 'organium'),
                    'section' => 'organium_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'organium'),
                        'right' => esc_html__('Right', 'organium'),
                        'none' => esc_html__('None', 'organium')
                    )
                )
            ));

            // ----------------------------------------- //
            // --- Single Portfolio Sidebar Position --- //
            // ----------------------------------------- //
            $wp_setting_name = 'portfolio_sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Single Portfolio Sidebar Position', 'organium'),
                    'section' => 'organium_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'organium'),
                        'right' => esc_html__('Right', 'organium'),
                        'none' => esc_html__('None', 'organium')
                    )
                )
            ));

            // -------------------------------------- //
            // --- Single Recipe Sidebar Position --- //
            // -------------------------------------- //
            $wp_setting_name = 'recipe_sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Single Recipe Sidebar Position', 'organium'),
                    'section' => 'organium_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'organium'),
                        'right' => esc_html__('Right', 'organium'),
                        'none' => esc_html__('None', 'organium')
                    )
                )
            ));

            if ( class_exists('WooCommerce')) {
                // -------------------------------------------- //
                // --- WooCommerce Catalog Sidebar Position --- //
                // -------------------------------------------- //
                $wp_setting_name = 'catalog_sidebar_position';
                $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback' => 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_html__('Catalog Sidebar Position', 'organium'),
                        'section' => 'organium_sidebar_settings',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'left' => esc_html__('Left', 'organium'),
                            'right' => esc_html__('Right', 'organium'),
                            'none' => esc_html__('None', 'organium')
                        )
                    )
                ));
            }

        // --------------------------------- //
        // ---------- Single Post ---------- //
        // --------------------------------- //
        $wp_customize->add_section('organium_single_post_settings',
            array(
                'title' => esc_html__('Single Post', 'organium'),
                'priority' => 200
            )
        );

            // ------------------------------ //
            // --- Media Output Container --- //
            // ------------------------------ //
            $wp_setting_name = 'media_output_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Media Output Container', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // ----------------- //
            // --- Post Meta --- //
            // ----------------- //
            $wp_setting_name = 'post_meta_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Post Meta', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // -------------------------------- //
            // --- Panel After Post Content --- //
            // -------------------------------- //
            $wp_setting_name = 'after_content_panel_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Panel After Post Content', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // --------------------- //
            // --- Post Comments --- //
            // --------------------- //
            $wp_setting_name = 'comments_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Post Comments', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // -------------------- //
            // --- Recent Posts --- //
            // -------------------- //
            $wp_setting_name = 'recent_posts_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    )
                )
            ));

            // ----------------------- //
            // --- Number of Posts --- //
            // ----------------------- //
            $wp_setting_name = 'recent_posts_number';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Number of Posts', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        '2' => esc_html__('2 Items', 'organium'),
                        '3' => esc_html__('3 Items', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ---------------- //
            // --- Order By --- //
            // ---------------- //
            $wp_setting_name = 'recent_posts_order_by';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Order By', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'random' => esc_html__('Random', 'organium'),
                        'date' => esc_html__('Date', 'organium'),
                        'name' => esc_html__('Name', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ------------------ //
            // --- Sort Order --- //
            // ------------------ //
            $wp_setting_name = 'recent_posts_order';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Sort Order', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'desc' => esc_html__('Descending', 'organium'),
                        'asc' => esc_html__('Ascending', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ------------------------------ //
            // --- Show Recent Post Image --- //
            // ------------------------------ //
            $wp_setting_name = 'recent_posts_image';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Featured Image', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // --------------------------------- //
            // --- Show Recent Post Category --- //
            // --------------------------------- //
            $wp_setting_name = 'recent_posts_category';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Categories', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ------------------------------ //
            // --- Show Recent Post Title --- //
            // ------------------------------ //
            $wp_setting_name = 'recent_posts_title';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Title', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ----------------------------- //
            // --- Show Recent Post Date --- //
            // ----------------------------- //
            $wp_setting_name = 'recent_posts_date';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Date', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ------------------------------- //
            // --- Show Recent Post Author --- //
            // ------------------------------- //
            $wp_setting_name = 'recent_posts_author';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Author', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // -------------------------------- //
            // --- Show Recent Post Excerpt --- //
            // -------------------------------- //
            $wp_setting_name = 'recent_posts_excerpt';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Excerpt', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // --------------------------------------- //
            // --- Show Recent Post Excerpt Length --- //
            // --------------------------------------- //
            $wp_setting_name = 'recent_posts_excerpt_length';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Excerpt Length', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'number',
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ----------------------------- //
            // --- Show Recent Post Tags --- //
            // ----------------------------- //
            $wp_setting_name = 'recent_posts_tags';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts Tags', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));

            // ----------------------------------------- //
            // --- Show Recent Post Read More Button --- //
            // ----------------------------------------- //
            $wp_setting_name = 'recent_posts_more';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Recent Posts \'Read More\' Button', 'organium'),
                    'section' => 'organium_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'organium'),
                        'hide' => esc_html__('Hide', 'organium')
                    ),
                    'description' => '<i class="organium_dependency_customizer" data-dependency-id="recent_posts_status" data-dependency-val="show"></i>'
                )
            ));


        // --------------------------------- //
        // ---------- Single Post ---------- //
        // --------------------------------- //
        $wp_customize->add_section('organium_404_page_settings',
            array(
                'title' => esc_html__('Error 404 Page', 'organium'),
                'priority' => 210
            )
        );

            // --------------------------- //
            // --- 404 Page Background --- //
            // --------------------------- //
            $wp_setting_name = '404_bg_image';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Background Image', 'organium'),
                    'section' => 'organium_404_page_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // --------------------------------- //
            // --- 404 Page Background Color --- //
            // --------------------------------- //
            $wp_setting_name = '404_bg_color';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Color_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Background Color', 'organium'),
                    'section' => 'organium_404_page_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ----------------------- //
            // --- 404 Error Title --- //
            // ----------------------- //
            $wp_setting_name = '404_title';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('404 Error Title', 'organium'),
                    'section' => 'organium_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));

            // ---------------------- //
            // --- 404 Error Text --- //
            // ---------------------- //
            $wp_setting_name = '404_text';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('404 Error Info Text', 'organium'),
                    'section' => 'organium_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));

            // ----------------------------- //
            // --- 404 Error Button Text --- //
            // ----------------------------- //
            $wp_setting_name = '404_button_text';
            $wp_customize->add_setting($wp_setting_name, array('default' => $organium_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Home Button Text', 'organium'),
                    'section' => 'organium_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));
    }
}


