<?php
/**
 * Wishlist page template - Organium Layout
 *
 * @author  Artureanec
 * @package YITH WooCommerce Wishlist
 * @version 1.0.0
 */

/**
 * Template variables:
 *
 * @var $wishlist                      \YITH_WCWL_Wishlist Current wishlist
 * @var $wishlist_items                array Array of items to show for current page
 * @var $wishlist_token                string Current wishlist token
 * @var $wishlist_id                   int Current wishlist id
 * @var $users_wishlists               array Array of current user wishlists
 * @var $current_page                  int Current page
 * @var $page_links                    array Array of page links
 * @var $is_user_owner                 bool Whether current user is wishlist owner
 * @var $show_price                    bool Whether to show price column
 * @var $show_dateadded                bool Whether to show item date of addition
 * @var $show_stock_status             bool Whether to show product stock status
 * @var $show_add_to_cart              bool Whether to show Add to Cart button
 * @var $show_remove_product           bool Whether to show Remove button
 * @var $show_price_variations         bool Whether to show price variation over time
 * @var $show_variation                bool Whether to show variation attributes when possible
 * @var $show_cb                       bool Whether to show checkbox column
 * @var $show_quantity                 bool Whether to show input quantity or not
 * @var $show_ask_estimate_button      bool Whether to show Ask an Estimate form
 * @var $show_last_column              bool Whether to show last column (calculated basing on previous flags)
 * @var $move_to_another_wishlist      bool Whether to show Move to another wishlist select
 * @var $move_to_another_wishlist_type string Whether to show a select or a popup for wishlist change
 * @var $additional_info               bool Whether to show Additional info textarea in Ask an estimate form
 * @var $price_excl_tax                bool Whether to show price excluding taxes
 * @var $enable_drag_n_drop            bool Whether to enable drag n drop feature
 * @var $repeat_remove_button          bool Whether to repeat remove button in last column
 * @var $available_multi_wishlist      bool Whether multi wishlist is enabled and available
 * @var $no_interactions               bool
 */

if ( ! defined( 'YITH_WCWL' ) ) {
	exit;
}
?>

<div class="organium_shop_loop shop_mode_grid<?php
    if ($no_interactions == true) {
        echo ' no-interactions';
    };
    ?>"
     data-pagination="<?php echo esc_attr( $pagination ); ?>" data-per-page="<?php echo esc_attr( $per_page ); ?>"
     data-page="<?php echo esc_attr( $current_page ); ?>" data-id="<?php echo esc_attr( $wishlist_id ); ?>"
     data-token="<?php echo esc_attr( $wishlist_token ); ?>"
>

    <?php
        if ( $wishlist && $wishlist->has_items() ) {
            echo '<ul class="products columns-4">';
            foreach ($wishlist_items as $item) {
                global $product;

                $product = $item->get_product();
                $availability = $product->get_availability();
                $stock_status = isset($availability['class']) ? $availability['class'] : false;

                if ($product && $product->exists()) { ?>
                    <li class="product">
                        <div class="woocommerce-loop-product__wrapper">
                            <div class="attachment-woocommerce_wrapper">
                                <?php echo sprintf('%s', $product->get_image()); ?>
                                <?php organium_wc_product_sale_flash(); ?>
                                <a href="<?php echo esc_url( add_query_arg( 'remove_from_wishlist', $item->get_product_id() ) ); ?>" class="remove_from_wishlist" title="<?php echo esc_attr__( 'Remove this product', 'organium' ); ?>"></a>
                                <a href="<?php echo esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $item->get_product_id() ) ) ); ?>" class="attachment-woocommerce_link"></a>
                            </div>
                            <div class="content-woocommerce_wrapper">
                                <h3 class="woocommerce-loop-product__title">
                                    <a href="<?php echo esc_url(get_permalink(apply_filters('woocommerce_in_cart_product', $item->get_product_id()))); ?>"><?php echo esc_html(apply_filters('woocommerce_in_cartproduct_obj_title', $product->get_title(), $product)); ?></a>
                                </h3>
                                <span class="price">
                                    <?php
                                        if ($show_price) {
                                            echo sprintf('%s', $item->get_formatted_product_price());
                                        }
                                    ?>
                                </span>
                                <?php woocommerce_template_loop_rating(); ?>
                            </div>
                            <div class="buttons-woocommerce_wrapper">
                                <?php
                                    $show_add_to_cart = apply_filters('yith_wcwl_table_product_show_add_to_cart', $show_add_to_cart, $item, $wishlist);
                                    if ($show_add_to_cart && isset($stock_status) && 'out-of-stock' !== $stock_status) {
                                        woocommerce_template_loop_add_to_cart(array('quantity' => $show_quantity ? $item->get_quantity() : 1));
                                    }
                                ?>
                            </div>
                        </div>
                    </li>
                <?php }
            }
            echo '</ul>';
        } else {
            echo '<div class="wishlist-empty">';
                echo esc_html__( 'No products added to the wishlist', 'organium' );
            echo '</div>';
        }
    ?>

    <?php if ( ! empty( $page_links ) ) { ?>
        <div class="wishlist-pagination">
            <?php echo sprintf('%s', $page_links); ?>
        </div>
    <?php } ?>
</div>